/*
 * File: Controller_Foreground.c
 *
 * Real-Time Workshop code generated for Simulink model Controller.
 *
 * Model version                        : 1.375
 * Real-Time Workshop file version      : 7.3  (R2009a)  15-Jan-2009
 * Real-Time Workshop file generated on : Mon Jan 11 12:01:09 2010
 * TLC version                          : 7.3 (Jan 18 2009)
 * C/C++ source code generated on       : Mon Jan 11 12:01:10 2010
 *
 * Target selection: motohawk_ert_rtw.tlc
 * Embedded hardware selection: Specified
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Controller_Foreground.h"

/* Include model header file for global data */
#include "Controller.h"
#include "Controller_private.h"

/* Named constants for Stateflow: '<S3>/Charge_Controller' */
#define Controller_IN_Charge           (1)
#define Controller_IN_Enable_Current_Tracking (2)
#define Controller_IN_Engine_Off       (3)
#define Controller_IN_Engine_On        (4)
#define Controller_IN_Initialize_b     (5)
#define Controller_IN_No_Charge        (6)
#define Controller_IN_Ramp_Down_Engine (7)
#define Controller_IN_Ramp_Up_Engine   (8)

/* Named constants for Stateflow: '<S3>/Startup_and_Shifting' */
#define Controller_IN_Battery_error    (1)
#define Controller_IN_Check_Battery    (2)
#define Controller_IN_Check_Generator  (3)
#define Controller_IN_Check_Motor      (4)
#define Controller_IN_Forward          (5)
#define Controller_IN_Generator_error  (6)
#define Controller_IN_Initialize       (7)
#define Controller_IN_Motor_error      (8)
#define Controller_IN_Park             (9)
#define Controller_IN_Reverse          (10)
#define Controller_event_Clock         (0U)

/* Initial conditions for function-call system: '<Root>/Foreground' */
void Controller_Foreground_Init(void)
{
  Controller_DWork.root_Foreground_PREV_T = Controller_M->Timing.clockTick0;

  /* InitializeConditions for Stateflow: '<S3>/Startup_and_Shifting' */
  Controller_DWork.s19_is_active_c2_Controller = 0U;
  Controller_DWork.s19_is_c2_Controller = 0U;
  Controller_B.s19_Vehicle_Ready = 0.0;
  Controller_B.s19_State = 0.0;
  Controller_B.s19_Battery_Connect_Command = 0.0;
  Controller_B.s19_Error = 0.0;
  Controller_B.s19_Motor_Enable = 0.0;
  Controller_B.s19_Gen_Enable = 0.0;
  Controller_B.s19_Forward_LED = 0.0;
  Controller_B.s19_Reverse_LED = 0.0;
  Controller_B.s19_Park_LED = 0.0;
  Controller_B.s19_Gear = 0.0;

  /* InitializeConditions for Stateflow: '<S3>/Charge_Controller' */
  Controller_DWork.s12_is_active_c1_Controller = 0U;
  Controller_DWork.s12_is_c1_Controller = 0U;
  Controller_B.s12_charge_current = 0.0;
  Controller_B.s12_Desired_Engine_rpm = 0.0;
  Controller_B.s12_Enable_Generator = 0.0;
  Controller_B.s12_Current_Feedback_Enable = 0.0;
  Controller_B.s12_Engine_On = 0.0;
  Controller_B.s12_Throttle_Offset = 0.0;
  Controller_B.s12_Current_Track = 0.0;
  Controller_B.s12_Charge_State = 0.0;

  /* S-Function Block: <S14>/motohawk_delta_time */
  {
    uint32_T now = 0;
    GetFreeRunningCounter32Bits(&now);
    Controller_DWork.s14_motohawk_delta_time_DWORK1 = now - (0.0);
  }

  /* S-Function Block: <S15>/motohawk_delta_time */
  {
    uint32_T now = 0;
    GetFreeRunningCounter32Bits(&now);
    Controller_DWork.s15_motohawk_delta_time_DWORK1 = now - (0.0);
  }
}

/* Start for function-call system: '<Root>/Foreground' */
void Controller_Foreground_Start(void)
{
  /* S-Function Block: FUELP */
  {
    VolatileWork.mh_init_resource_FUELP = -1;
  }

  /* S-Function Block: TACH */
  {
    VolatileWork.mh_init_resource_TACH = -1;
  }

  /* S-Function Block: INJ1D */
  {
    VolatileWork.mh_init_resource_INJ1D = -1;
  }

  /* S-Function Block: INJ2D */
  {
    VolatileWork.mh_init_resource_INJ2D = -1;
  }

  /* S-Function Block: INJ3D */
  {
    VolatileWork.mh_init_resource_INJ3D = -1;
  }
}

/* Output and update for function-call system: '<Root>/Foreground' */
void Controller_Foreground(void)
{
  /* local block i/o variables */
  real_T rtb_sampletime;
  real_T rtb_sampletime_d;
  real_T rtb_sampletime_p;
  real_T rtb_Gain_a;
  real_T rtb_MinMax;
  real_T rtb_Sum2;
  real_T rtb_sampletime_h;
  real_T rtb_Switch;
  real_T rtb_Abs;
  real_T rtb_DisableRegen2;
  real_T rtb_DisableRegen;
  real_T rtb_sampletime_n;
  real_T rtb_Saturation1_i;
  real_T rtb_RegenBraking;
  real_T rtb_FoundationBraking;
  real_T rtb_RegenBraking1;
  real_T rtb_DisableRegen1;
  real_T rtb_Abs1;
  real_T rtb_DisableRegen3;
  real_T rtb_motohawk_delta_time;
  real_T rtb_motohawk_delta_time_k;
  uint16_T rtb_motohawk_ain1;
  boolean_T rtb_motohawk_din;
  boolean_T rtb_motohawk_din1;
  boolean_T rtb_motohawk_din2;
  boolean_T rtb_DataTypeConversion3;
  boolean_T rtb_DataTypeConversion4;
  boolean_T rtb_DataTypeConversion5;
  boolean_T rtb_DataTypeConversion6;
  boolean_T rtb_DataTypeConversion7;

  {
    uint8_T sf_previousEvent;
    real_T rtb_Sum_c;
    real_T rtb_SineWave;
    ZCEventType zcEvent;
    real_T rtb_UkYk1;
    real_T rtb_Yk;
    real_T rtb_UnitDelay_l;
    real_T rtb_Switch2;
    real_T rtb_Sum;
    real_T rtb_Yk_k;
    real_T rtb_UnitDelay_b3;
    real_T rtb_Yk_e;
    real_T rtb_Yk_d;
    Controller_DWork.root_Foreground_ELAPS_T = Controller_M->Timing.clockTick0 -
      Controller_DWork.root_Foreground_PREV_T;
    Controller_DWork.root_Foreground_PREV_T = Controller_M->Timing.clockTick0;

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_645p0004;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_645p0004,
        &messageObj);
      if (msg_valid) {
        uint16_T tmp0 = 0;
        uint16_T tmp1 = 0;
        int16_T tmp2 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[1])) ;
        ((uint8_T *)(&tmp0))[1] = ((messageObj.u1DataArr[0])) ;
        ((uint8_T *)(&tmp1))[0] = ((messageObj.u1DataArr[3])) ;
        ((uint8_T *)(&tmp1))[1] = ((messageObj.u1DataArr[2])) ;
        ((uint8_T *)(&tmp2))[0] = ((messageObj.u1DataArr[5])) ;
        ((uint8_T *)(&tmp2))[1] = ((messageObj.u1DataArr[4])) ;
        Controller_B.s1_ReadCANMessage_o1 = ((real_T) tmp0) / ((real_T) 65530.8);
        Controller_B.s1_ReadCANMessage_o2 = ((real_T) tmp1) / ((real_T) 131.068);
        Controller_B.s1_ReadCANMessage_o3 = ((real_T) tmp2) / ((real_T) 109.218);
      }
    }

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_648p0001;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_648p0001,
        &messageObj);
      if (msg_valid) {
        int16_T tmp0 = 0;
        int16_T tmp1 = 0;
        int16_T tmp2 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[0])) ;
        ((uint8_T *)(&tmp0))[1] = ((messageObj.u1DataArr[1])) ;
        ((uint8_T *)(&tmp1))[0] = ((messageObj.u1DataArr[2])) ;
        ((uint8_T *)(&tmp1))[1] = ((messageObj.u1DataArr[3])) ;
        ((uint8_T *)(&tmp2))[0] = ((messageObj.u1DataArr[4])) ;
        ((uint8_T *)(&tmp2))[1] = ((messageObj.u1DataArr[5])) ;
        Controller_B.s1_ReadCANMessage3_o1 = ((real_T) tmp0) / ((real_T) 6.55308);
        Controller_B.s1_ReadCANMessage3_o2 = ((real_T) tmp1) / ((real_T) 109.225);
        Controller_B.s1_ReadCANMessage3_o3 = ((real_T) tmp2) / ((real_T) 109.225);
      }
    }

    /* Gain: '<S1>/seconds per hour' incorporates:
     *  Gain: '<S1>/Gain6'
     *  Gain: '<S1>/Rear Diff Ratio'
     *  Gain: '<S1>/Tire Radius (m)'
     *  Gain: '<S1>/miles per meter'
     */
    Controller_B.s1_secondsperhour = 1.0471975511965977E-001 *
      Controller_B.s1_ReadCANMessage3_o1 * 2.6809651474530832E-001 * 0.406 *
      6.2150403977625850E-004 * 3600.0;

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_649p0001;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_649p0001,
        &messageObj);
      if (msg_valid) {
        uint8_T tmp0 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[0])) ;
        Controller_B.s1_ReadCANMessage4 = (real_T) tmp0;
      }
    }

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_650p0001;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_650p0001,
        &messageObj);
      if (msg_valid) {
        uint8_T tmp0 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[0])) ;
        Controller_B.s1_ReadCANMessage5 = (real_T) tmp0;
      }
    }

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_651p0001;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_651p0001,
        &messageObj);
      if (msg_valid) {
        uint8_T tmp0 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[0])) ;
        Controller_B.s1_ReadCANMessage6 = (real_T) tmp0;
      }
    }

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_647p0001;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_647p0001,
        &messageObj);
      if (msg_valid) {
        uint16_T tmp0 = 0;
        uint8_T tmp1 = 0;
        uint16_T tmp2 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[1])) ;
        ((uint8_T *)(&tmp0))[1] = ((messageObj.u1DataArr[0])) ;
        ((uint8_T *)(&tmp1))[0] = ((messageObj.u1DataArr[2])) ;
        ((uint8_T *)(&tmp2))[0] = ((messageObj.u1DataArr[4])) ;
        ((uint8_T *)(&tmp2))[1] = ((messageObj.u1DataArr[3])) ;
        Controller_B.s1_ReadCANMessage2_o1 = ((real_T) tmp0) / ((real_T) 13.107);
        Controller_B.s1_ReadCANMessage2_o2 = ((real_T) tmp1) / ((real_T) 12.75);
        Controller_B.s1_ReadCANMessage2_o3 = ((real_T) tmp2) / ((real_T) 218.45);
      }
    }

    /* MotoHawk Read CAN Message */
    {
      S_CANMessage messageObj;
      extern MHCAN_directslot MHCAN_directslot_RxSlot_646p0001;
      extern boolean_T MHCAN_getdirect(MHCAN_directslot *directslot,
        S_CANMessage *messageObj);
      boolean_T msg_valid = MHCAN_getdirect(&MHCAN_directslot_RxSlot_646p0001,
        &messageObj);
      if (msg_valid) {
        int16_T tmp0 = 0;
        int16_T tmp1 = 0;
        int16_T tmp2 = 0;
        ((uint8_T *)(&tmp0))[0] = ((messageObj.u1DataArr[0])) ;
        ((uint8_T *)(&tmp0))[1] = ((messageObj.u1DataArr[1])) ;
        ((uint8_T *)(&tmp1))[0] = ((messageObj.u1DataArr[2])) ;
        ((uint8_T *)(&tmp1))[1] = ((messageObj.u1DataArr[3])) ;
        ((uint8_T *)(&tmp2))[0] = ((messageObj.u1DataArr[4])) ;
        ((uint8_T *)(&tmp2))[1] = ((messageObj.u1DataArr[5])) ;
        Controller_B.s1_ReadCANMessage1_o1 = ((real_T) tmp0) / ((real_T) 6.55308);
        Controller_B.s1_ReadCANMessage1_o2 = ((real_T) tmp1) / ((real_T) 109.225);
        Controller_B.s1_ReadCANMessage1_o3 = ((real_T) tmp2) / ((real_T) 109.225);
      }
    }

    /* S-Function Block: <S1>/motohawk_ain Resource: AN4M */
    {
      extern NativeError_S AN4M_AnalogInput_Get(uint16_T *adc, uint16_T *status);
      AN4M_AnalogInput_Get(&rtb_motohawk_ain1, NULL);
    }

    /* Sum: '<S1>/Sum' incorporates:
     *  Constant: '<S1>/Constant'
     *  DataTypeConversion: '<S1>/Data Type Conversion1'
     *  Gain: '<S1>/Gain'
     */
    Controller_B.s1_Sum = 1.0 - 9.7751710654936461E-004 * (real_T)
      rtb_motohawk_ain1;
    VolatileWork.mh_Vehicle_Key = 1.0;

    /* S-Function Block: <S1>/motohawk_ain1 Resource: AN5M */
    {
      extern NativeError_S AN5M_AnalogInput_Get(uint16_T *adc, uint16_T *status);
      AN5M_AnalogInput_Get(&rtb_motohawk_ain1, NULL);
    }

    /* Sum: '<S1>/Sum1' incorporates:
     *  Constant: '<S1>/Constant1'
     *  DataTypeConversion: '<S1>/Data Type Conversion2'
     *  Gain: '<S1>/Gain1'
     */
    Controller_B.s1_Sum1 = 1.0 - 9.7751710654936461E-004 * (real_T)
      rtb_motohawk_ain1;

    /* S-Function Block: <S1>/motohawk_din Resource: AN6M */
    {
      extern NativeError_S AN6M_DigitalInput_Get(boolean_T *out, uint16_T
        *status);
      AN6M_DigitalInput_Get(&rtb_motohawk_din, NULL);
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion8' incorporates:
     *  Logic: '<S1>/Logical Operator'
     *  S-Function (motohawk_sfun_din): '<S1>/motohawk_din'
     */
    Controller_B.s1_DataTypeConversion8 = (real_T)!rtb_motohawk_din;

    /* S-Function Block: <S1>/motohawk_din1 Resource: AN1M */
    {
      extern NativeError_S AN1M_DigitalInput_Get(boolean_T *out, uint16_T
        *status);
      AN1M_DigitalInput_Get(&rtb_motohawk_din1, NULL);
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion9' incorporates:
     *  Logic: '<S1>/Logical Operator1'
     *  S-Function (motohawk_sfun_din): '<S1>/motohawk_din1'
     */
    Controller_B.s1_DataTypeConversion9 = (real_T)!rtb_motohawk_din1;

    /* S-Function Block: <S1>/motohawk_din2 Resource: AN2M */
    {
      extern NativeError_S AN2M_DigitalInput_Get(boolean_T *out, uint16_T
        *status);
      AN2M_DigitalInput_Get(&rtb_motohawk_din2, NULL);
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion10' incorporates:
     *  Logic: '<S1>/Logical Operator2'
     *  S-Function (motohawk_sfun_din): '<S1>/motohawk_din2'
     */
    Controller_B.s1_DataTypeConversion10 = (real_T)!rtb_motohawk_din2;

    /* Sin: '<S3>/Sine Wave' */
    rtb_SineWave = sin(6.2831853071795865E+002 *
                       (((Controller_M->Timing.clockTick0 +
                          Controller_M->Timing.clockTickH0* 4294967296.0)) *
                        1.0E-006));
    zcEvent = rt_ZCFcn(RISING_ZERO_CROSSING,
                       &Controller_PrevZCSigState.Startup_and_Shifting_Trig_ZCE,
                       (rtb_SineWave));
    if (zcEvent != NO_ZCEVENT) {
      /* Stateflow: '<S3>/Startup_and_Shifting' incorporates:
       *  Constant: '<S1>/Vehicle_Key'
       */
      sf_previousEvent = _sfEvent_Controller_;
      _sfEvent_Controller_ = Controller_event_Clock;

      /* Gateway: Foreground/Control/Startup_and_Shifting */
      /* During: Foreground/Control/Startup_and_Shifting */
      if ((_sfEvent_Controller_ == Controller_event_Clock) &&
          (Controller_DWork.s19_temporalCounter_i1 < 511)) {
        Controller_DWork.s19_temporalCounter_i1 = (uint16_T)
          (Controller_DWork.s19_temporalCounter_i1 + 1);
      }

      if (Controller_DWork.s19_is_active_c2_Controller == 0) {
        /* Entry: Foreground/Control/Startup_and_Shifting */
        Controller_DWork.s19_is_active_c2_Controller = 1U;

        /* Transition: '<S19>:15' */
        /* Entry 'Initialize': '<S19>:5' */
        Controller_DWork.s19_is_c2_Controller = (uint8_T)
          Controller_IN_Initialize;
        Controller_B.s19_State = 0.0;
        Controller_B.s19_Vehicle_Ready = 0.0;
        Controller_B.s19_Battery_Connect_Command = 0.0;
        Controller_B.s19_Motor_Enable = 0.0;
        Controller_B.s19_Gen_Enable = 0.0;
        Controller_B.s19_Park_LED = 1.0;
        Controller_B.s19_Forward_LED = 0.0;
        Controller_B.s19_Reverse_LED = 0.0;
        Controller_B.s19_Gear = 0.0;
      } else {
        switch (Controller_DWork.s19_is_c2_Controller) {
         case Controller_IN_Battery_error:
          break;

         case Controller_IN_Check_Battery:
          /* During 'Check_Battery': '<S19>:6' */
          if (Controller_B.s1_ReadCANMessage4 == 4.0) {
            /* Transition: '<S19>:12' */
            /* Exit 'Check_Battery': '<S19>:6' */
            /* Entry 'Check_Motor': '<S19>:13' */
            Controller_DWork.s19_is_c2_Controller = (uint8_T)
              Controller_IN_Check_Motor;
            Controller_DWork.s19_temporalCounter_i1 = 0U;
            Controller_B.s19_State = 3.0;
            Controller_B.s19_Motor_Enable = 1.0;
          } else {
            if ((_sfEvent_Controller_ == Controller_event_Clock) &&
                (Controller_DWork.s19_temporalCounter_i1 >= 500) &&
                (Controller_B.s1_ReadCANMessage4 != 4.0)) {
              /* Transition: '<S19>:10' */
              /* Exit 'Check_Battery': '<S19>:6' */
              /* Entry 'Battery_error': '<S19>:9' */
              Controller_DWork.s19_is_c2_Controller = (uint8_T)
                Controller_IN_Battery_error;
              Controller_B.s19_State = 6.0;
              Controller_B.s19_Error = 1.0;
              Controller_B.s19_Battery_Connect_Command = 0.0;
            }
          }
          break;

         case Controller_IN_Check_Generator:
          /* During 'Check_Generator': '<S19>:18' */
          if ((_sfEvent_Controller_ == Controller_event_Clock) &&
              (Controller_DWork.s19_temporalCounter_i1 >= 150) &&
              (Controller_B.s1_ReadCANMessage5 != 1.0)) {
            /* Transition: '<S19>:22' */
            /* Exit 'Check_Generator': '<S19>:18' */
            /* Entry 'Generator_error': '<S19>:21' */
            Controller_DWork.s19_is_c2_Controller = (uint8_T)
              Controller_IN_Generator_error;
            Controller_B.s19_State = 8.0;
            Controller_B.s19_Error = 1.0;
            Controller_B.s19_Motor_Enable = 0.0;
            Controller_B.s19_Battery_Connect_Command = 0.0;
            Controller_B.s19_Gen_Enable = 0.0;
          } else {
            if (Controller_B.s1_ReadCANMessage5 == 1.0) {
              /* Transition: '<S19>:27' */
              /* Exit 'Check_Generator': '<S19>:18' */
              /* Entry 'Park': '<S19>:43' */
              Controller_DWork.s19_is_c2_Controller = (uint8_T)
                Controller_IN_Park;
              Controller_B.s19_State = 9.0;
              Controller_B.s19_Park_LED = 1.0;
              Controller_B.s19_Forward_LED = 0.0;
              Controller_B.s19_Reverse_LED = 0.0;
              Controller_B.s19_Gear = 0.0;
              Controller_B.s19_Vehicle_Ready = 1.0;
            }
          }
          break;

         case Controller_IN_Check_Motor:
          /* During 'Check_Motor': '<S19>:13' */
          if ((_sfEvent_Controller_ == Controller_event_Clock) &&
              (Controller_DWork.s19_temporalCounter_i1 >= 150) &&
              (Controller_B.s1_ReadCANMessage6 != 1.0)) {
            /* Transition: '<S19>:19' */
            /* Exit 'Check_Motor': '<S19>:13' */
            /* Entry 'Motor_error': '<S19>:20' */
            Controller_DWork.s19_is_c2_Controller = (uint8_T)
              Controller_IN_Motor_error;
            Controller_B.s19_State = 7.0;
            Controller_B.s19_Error = 1.0;
            Controller_B.s19_Motor_Enable = 0.0;
            Controller_B.s19_Battery_Connect_Command = 0.0;
          } else {
            if (Controller_B.s1_ReadCANMessage6 == 1.0) {
              /* Transition: '<S19>:24' */
              /* Exit 'Check_Motor': '<S19>:13' */
              /* Entry 'Check_Generator': '<S19>:18' */
              Controller_DWork.s19_is_c2_Controller = (uint8_T)
                Controller_IN_Check_Generator;
              Controller_DWork.s19_temporalCounter_i1 = 0U;
              Controller_B.s19_State = 4.0;
              Controller_B.s19_Gen_Enable = 1.0;
            }
          }
          break;

         case Controller_IN_Forward:
          /* During 'Forward': '<S19>:44' */
          if ((Controller_B.s1_Sum1 >= 0.5) && (Controller_B.s1_Sum <= 0.05) &&
              (Controller_B.s1_DataTypeConversion9 == 0.0) && (fabs
               (Controller_B.s1_secondsperhour) < 1.0) &&
              ((Controller_B.s1_DataTypeConversion8 == 1.0) ||
               (Controller_B.s1_DataTypeConversion10 == 1.0))) {
            /* Transition: '<S19>:46' */
            /* Exit 'Forward': '<S19>:44' */
            /* Entry 'Park': '<S19>:43' */
            Controller_DWork.s19_is_c2_Controller = (uint8_T)Controller_IN_Park;
            Controller_B.s19_State = 9.0;
            Controller_B.s19_Park_LED = 1.0;
            Controller_B.s19_Forward_LED = 0.0;
            Controller_B.s19_Reverse_LED = 0.0;
            Controller_B.s19_Gear = 0.0;
            Controller_B.s19_Vehicle_Ready = 1.0;
          }
          break;

         case Controller_IN_Generator_error:
          break;

         case Controller_IN_Initialize:
          /* During 'Initialize': '<S19>:5' */
          /* Transition: '<S19>:7' */
          /* Exit 'Initialize': '<S19>:5' */
          /* Entry 'Check_Battery': '<S19>:6' */
          Controller_DWork.s19_is_c2_Controller = (uint8_T)
            Controller_IN_Check_Battery;
          Controller_DWork.s19_temporalCounter_i1 = 0U;
          Controller_B.s19_State = 2.0;
          Controller_B.s19_Battery_Connect_Command = 1.0;
          break;

         case Controller_IN_Motor_error:
          break;

         case Controller_IN_Park:
          /* During 'Park': '<S19>:43' */
          if ((Controller_B.s1_Sum1 >= 0.5) && (Controller_B.s1_Sum <= 0.05) &&
              (Controller_B.s1_DataTypeConversion9 == 1.0) &&
              (Controller_B.s1_DataTypeConversion8 == 0.0) &&
              (Controller_B.s1_DataTypeConversion10 == 0.0)) {
            /* Transition: '<S19>:45' */
            /* Exit 'Park': '<S19>:43' */
            /* Entry 'Forward': '<S19>:44' */
            Controller_DWork.s19_is_c2_Controller = (uint8_T)
              Controller_IN_Forward;
            Controller_B.s19_State = 10.0;
            Controller_B.s19_Park_LED = 0.0;
            Controller_B.s19_Forward_LED = 1.0;
            Controller_B.s19_Gear = 1.0;
          } else {
            if ((Controller_B.s1_Sum1 >= 0.5) && (Controller_B.s1_Sum <= 0.05) &&
                (Controller_B.s1_DataTypeConversion9 == 0.0) &&
                (Controller_B.s1_DataTypeConversion8 == 0.0) &&
                (Controller_B.s1_DataTypeConversion10 == 1.0)) {
              /* Transition: '<S19>:47' */
              /* Exit 'Park': '<S19>:43' */
              /* Entry 'Reverse': '<S19>:42' */
              Controller_DWork.s19_is_c2_Controller = (uint8_T)
                Controller_IN_Reverse;
              Controller_B.s19_State = 11.0;
              Controller_B.s19_Park_LED = 0.0;
              Controller_B.s19_Reverse_LED = 1.0;
              Controller_B.s19_Gear = -1.0;
            }
          }
          break;

         case Controller_IN_Reverse:
          /* During 'Reverse': '<S19>:42' */
          if ((Controller_B.s1_Sum1 >= 0.5) && (Controller_B.s1_Sum <= 0.05) &&
              (Controller_B.s1_DataTypeConversion10 == 0.0) && (fabs
               (Controller_B.s1_secondsperhour) < 1.0) &&
              ((Controller_B.s1_DataTypeConversion8 == 1.0) ||
               (Controller_B.s1_DataTypeConversion9 == 1.0))) {
            /* Transition: '<S19>:48' */
            /* Exit 'Reverse': '<S19>:42' */
            /* Entry 'Park': '<S19>:43' */
            Controller_DWork.s19_is_c2_Controller = (uint8_T)Controller_IN_Park;
            Controller_B.s19_State = 9.0;
            Controller_B.s19_Park_LED = 1.0;
            Controller_B.s19_Forward_LED = 0.0;
            Controller_B.s19_Reverse_LED = 0.0;
            Controller_B.s19_Gear = 0.0;
            Controller_B.s19_Vehicle_Ready = 1.0;
          }
          break;

         default:
          /* Transition: '<S19>:15' */
          /* Entry 'Initialize': '<S19>:5' */
          Controller_DWork.s19_is_c2_Controller = (uint8_T)
            Controller_IN_Initialize;
          Controller_B.s19_State = 0.0;
          Controller_B.s19_Vehicle_Ready = 0.0;
          Controller_B.s19_Battery_Connect_Command = 0.0;
          Controller_B.s19_Motor_Enable = 0.0;
          Controller_B.s19_Gen_Enable = 0.0;
          Controller_B.s19_Park_LED = 1.0;
          Controller_B.s19_Forward_LED = 0.0;
          Controller_B.s19_Reverse_LED = 0.0;
          Controller_B.s19_Gear = 0.0;
          break;
        }
      }

      _sfEvent_Controller_ = sf_previousEvent;
    }

    zcEvent = rt_ZCFcn(RISING_ZERO_CROSSING,
                       &Controller_PrevZCSigState.Charge_Controller_Trig_ZCE,
                       (rtb_SineWave));
    if (zcEvent != NO_ZCEVENT) {
      /* Stateflow: '<S3>/Charge_Controller' */
      /* Gateway: Foreground/Control/Charge_Controller */
      /* During: Foreground/Control/Charge_Controller */
      if (Controller_DWork.s12_is_active_c1_Controller == 0) {
        /* Entry: Foreground/Control/Charge_Controller */
        Controller_DWork.s12_is_active_c1_Controller = 1U;

        /* Transition: '<S12>:28' */
        /* Entry 'Initialize': '<S12>:23' */
        Controller_DWork.s12_is_c1_Controller = (uint8_T)
          Controller_IN_Initialize_b;
        Controller_B.s12_Enable_Generator = 0.0;
        Controller_B.s12_Desired_Engine_rpm = 0.0;
        Controller_B.s12_charge_current = 0.0;
        Controller_B.s12_Current_Feedback_Enable = 0.0;
        Controller_B.s12_Engine_On = 0.0;
        Controller_B.s12_Throttle_Offset = 0.0;
        Controller_B.s12_Current_Track = 0.0;
        Controller_B.s12_Charge_State = 0.0;
      } else {
        switch (Controller_DWork.s12_is_c1_Controller) {
         case Controller_IN_Charge:
          /* During 'Charge': '<S12>:22' */
          if (Controller_B.s1_ReadCANMessage_o1 >= 0.7) {
            /* Transition: '<S12>:27' */
            /* Exit 'Charge': '<S12>:22' */
            /* Entry 'Ramp_Down_Engine': '<S12>:25' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_Ramp_Down_Engine;
            Controller_B.s12_Desired_Engine_rpm = 0.0;
            Controller_B.s12_charge_current = 0.0;
            Controller_B.s12_Current_Feedback_Enable = 0.0;
            Controller_B.s12_Throttle_Offset = 0.0;
            Controller_B.s12_Charge_State = 6.0;
          } else {
            if (Controller_B.s1_ReadCANMessage_o1 <= 0.5) {
              /* Transition: '<S12>:49' */
              /* Exit 'Charge': '<S12>:22' */
              /* Entry 'Enable_Current_Tracking': '<S12>:47' */
              Controller_DWork.s12_is_c1_Controller = (uint8_T)
                Controller_IN_Enable_Current_Tracking;
              Controller_B.s12_Current_Track = 1.0;
              Controller_B.s12_Charge_State = 5.0;
            }
          }
          break;

         case Controller_IN_Enable_Current_Tracking:
          /* During 'Enable_Current_Tracking': '<S12>:47' */
          if (Controller_B.s1_ReadCANMessage_o1 >= 0.7) {
            /* Transition: '<S12>:50' */
            /* Exit 'Enable_Current_Tracking': '<S12>:47' */
            Controller_B.s12_Current_Track = 0.0;

            /* Entry 'Ramp_Down_Engine': '<S12>:25' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_Ramp_Down_Engine;
            Controller_B.s12_Desired_Engine_rpm = 0.0;
            Controller_B.s12_charge_current = 0.0;
            Controller_B.s12_Current_Feedback_Enable = 0.0;
            Controller_B.s12_Throttle_Offset = 0.0;
            Controller_B.s12_Charge_State = 6.0;
          }
          break;

         case Controller_IN_Engine_Off:
          /* During 'Engine_Off': '<S12>:42' */
          if (Controller_B.s1_ReadCANMessage2_o1 <= 10.0) {
            /* Transition: '<S12>:31' */
            /* Exit 'Engine_Off': '<S12>:42' */
            /* Entry 'No_Charge': '<S12>:21' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_No_Charge;
            Controller_B.s12_Enable_Generator = 0.0;
            Controller_B.s12_Desired_Engine_rpm = 0.0;
            Controller_B.s12_charge_current = 0.0;
            Controller_B.s12_Charge_State = 1.0;
          }
          break;

         case Controller_IN_Engine_On:
          /* During 'Engine_On': '<S12>:39' */
          if (Controller_B.s1_ReadCANMessage2_o1 >= 1790.0) {
            /* Transition: '<S12>:30' */
            /* Exit 'Engine_On': '<S12>:39' */
            /* Entry 'Charge': '<S12>:22' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_Charge;
            Controller_B.s12_charge_current = 50.0;
            Controller_B.s12_Current_Feedback_Enable = 1.0;
            Controller_B.s12_Charge_State = 4.0;
          }
          break;

         case Controller_IN_Initialize_b:
          /* During 'Initialize': '<S12>:23' */
          if (Controller_B.s19_Vehicle_Ready == 1.0) {
            /* Transition: '<S12>:29' */
            /* Exit 'Initialize': '<S12>:23' */
            /* Entry 'No_Charge': '<S12>:21' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_No_Charge;
            Controller_B.s12_Enable_Generator = 0.0;
            Controller_B.s12_Desired_Engine_rpm = 0.0;
            Controller_B.s12_charge_current = 0.0;
            Controller_B.s12_Charge_State = 1.0;
          }
          break;

         case Controller_IN_No_Charge:
          /* During 'No_Charge': '<S12>:21' */
          if (Controller_B.s1_ReadCANMessage_o1 <= 0.6) {
            /* Transition: '<S12>:26' */
            /* Exit 'No_Charge': '<S12>:21' */
            /* Entry 'Ramp_Up_Engine': '<S12>:24' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_Ramp_Up_Engine;
            Controller_B.s12_Enable_Generator = 1.0;
            Controller_B.s12_Desired_Engine_rpm = 1800.0;
            Controller_B.s12_Charge_State = 2.0;
          }
          break;

         case Controller_IN_Ramp_Down_Engine:
          /* During 'Ramp_Down_Engine': '<S12>:25' */
          if (Controller_B.s1_ReadCANMessage2_o1 <= 800.0) {
            /* Transition: '<S12>:43' */
            /* Exit 'Ramp_Down_Engine': '<S12>:25' */
            /* Entry 'Engine_Off': '<S12>:42' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_Engine_Off;
            Controller_B.s12_Engine_On = 0.0;
            Controller_B.s12_Charge_State = 7.0;
          }
          break;

         case Controller_IN_Ramp_Up_Engine:
          /* During 'Ramp_Up_Engine': '<S12>:24' */
          if (Controller_B.s1_ReadCANMessage2_o1 >= 800.0) {
            /* Transition: '<S12>:40' */
            /* Exit 'Ramp_Up_Engine': '<S12>:24' */
            /* Entry 'Engine_On': '<S12>:39' */
            Controller_DWork.s12_is_c1_Controller = (uint8_T)
              Controller_IN_Engine_On;
            Controller_B.s12_Engine_On = 1.0;
            Controller_B.s12_Throttle_Offset = 0.2;
            Controller_B.s12_Charge_State = 3.0;
          }
          break;

         default:
          /* Transition: '<S12>:28' */
          /* Entry 'Initialize': '<S12>:23' */
          Controller_DWork.s12_is_c1_Controller = (uint8_T)
            Controller_IN_Initialize_b;
          Controller_B.s12_Enable_Generator = 0.0;
          Controller_B.s12_Desired_Engine_rpm = 0.0;
          Controller_B.s12_charge_current = 0.0;
          Controller_B.s12_Current_Feedback_Enable = 0.0;
          Controller_B.s12_Engine_On = 0.0;
          Controller_B.s12_Throttle_Offset = 0.0;
          Controller_B.s12_Current_Track = 0.0;
          Controller_B.s12_Charge_State = 0.0;
          break;
        }
      }
    }

    /* S-Function (sfix_tsampmath): '<S16>/sample time' */

    /* Sample Time Math Block: '<S16>/sample time'
     *
     * y = K         where     K = ( w * Ts )
     *
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * ElapsedTime Data Type:  Floating Point real_T
     */
    rtb_sampletime = (((Controller_DWork.root_Foreground_ELAPS_T * 1.0E-006))*
                      (1.0));

    /* Product: '<S16>/delta rise limit' incorporates:
     *  Constant: '<S16>/Constant'
     */
    rtb_Sum_c = 900.0 * rtb_sampletime;

    /* Sum: '<S16>/Difference Inputs1' incorporates:
     *  UnitDelay: '<S16>/Delay Input2'
     */
    rtb_UkYk1 = Controller_B.s12_Desired_Engine_rpm -
      Controller_DWork.s16_DelayInput2_DSTATE;

    /* Switch: '<S25>/Switch2' incorporates:
     *  RelationalOperator: '<S25>/LowerRelop1'
     */
    if (!(rtb_UkYk1 > rtb_Sum_c)) {
      /* Product: '<S16>/delta fall limit' incorporates:
       *  Constant: '<S16>/Constant1'
       */
      rtb_SineWave = -900.0 * rtb_sampletime;

      /* Switch: '<S25>/Switch' incorporates:
       *  RelationalOperator: '<S25>/UpperRelop'
       */
      if (rtb_UkYk1 < rtb_SineWave) {
        rtb_UkYk1 = rtb_SineWave;
      }

      rtb_Sum_c = rtb_UkYk1;
    }

    /* Sum: '<S16>/Difference Inputs2' incorporates:
     *  UnitDelay: '<S16>/Delay Input2'
     */
    rtb_Yk = rtb_Sum_c + Controller_DWork.s16_DelayInput2_DSTATE;

    /* Sum: '<S3>/Sum' */
    rtb_Sum_c = rtb_Yk - Controller_B.s1_ReadCANMessage2_o1;

    /* UnitDelay: '<S14>/Unit Delay' */
    rtb_UnitDelay_l = Controller_DWork.s14_UnitDelay_DSTATE;

    /* Sum: '<S3>/Sum3' incorporates:
     *  Gain: '<S3>/Gain'
     *  Product: '<S3>/Product3'
     *  S-Function (motohawk_sfun_calibration): '<S3>/motohawk_calibration1'
     */
    rtb_Switch2 = 0.01 * rtb_Sum_c * ConstantWork.mh_Speed_Feedback_P_Gain +
      Controller_DWork.s14_UnitDelay_DSTATE;

    /* Product: '<S3>/Product' incorporates:
     *  Saturate: '<S3>/Saturation'
     */
    Controller_B.s3_Product = Controller_B.s12_Enable_Generator * rt_SATURATE
      (rtb_Switch2, -1.0, 1.0);

    /* S-Function (sfix_tsampmath): '<S18>/sample time' */

    /* Sample Time Math Block: '<S18>/sample time'
     *
     * y = K         where     K = ( w * Ts )
     *
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * ElapsedTime Data Type:  Floating Point real_T
     */
    rtb_sampletime_d = (((Controller_DWork.root_Foreground_ELAPS_T * 1.0E-006))*
                        (1.0));

    /* Product: '<S18>/delta rise limit' incorporates:
     *  Constant: '<S18>/Constant'
     */
    rtb_Switch2 = rtb_sampletime_d;

    /* S-Function (sfix_tsampmath): '<S17>/sample time' */

    /* Sample Time Math Block: '<S17>/sample time'
     *
     * y = K         where     K = ( w * Ts )
     *
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * ElapsedTime Data Type:  Floating Point real_T
     */
    rtb_sampletime_p = (((Controller_DWork.root_Foreground_ELAPS_T * 1.0E-006))*
                        (1.0));

    /* Product: '<S17>/delta rise limit' incorporates:
     *  Constant: '<S17>/Constant'
     */
    rtb_SineWave = 50.0 * rtb_sampletime_p;

    /* Gain: '<S13>/Gain' incorporates:
     *  Saturate: '<S13>/Saturation'
     */
    rtb_Gain_a = -1.2 * rt_MINd_snf(Controller_B.s1_ReadCANMessage3_o2, 0.0);

    /* DiscreteTransferFcn: '<S13>/Discrete Transfer Fcn' */
    Controller_B.s13_DiscreteTransferFcn = 1.5683340832810533E-003*rtb_Gain_a;
    Controller_B.s13_DiscreteTransferFcn += 3.1317488229685446E-003*
      Controller_DWork.s13_DiscreteTransferFcn_DSTATE;

    /* Product: '<S13>/Product' */
    rtb_Sum = Controller_B.s13_DiscreteTransferFcn *
      Controller_B.s12_Current_Track;

    /* MinMax: '<S13>/MinMax' */
    rtb_MinMax = rt_MAXd_snf(Controller_B.s12_charge_current, rtb_Sum);

    /* Sum: '<S17>/Difference Inputs1' incorporates:
     *  UnitDelay: '<S17>/Delay Input2'
     */
    rtb_UkYk1 = rtb_MinMax - Controller_DWork.s17_DelayInput2_DSTATE;

    /* Switch: '<S26>/Switch2' incorporates:
     *  RelationalOperator: '<S26>/LowerRelop1'
     */
    if (!(rtb_UkYk1 > rtb_SineWave)) {
      /* Product: '<S17>/delta fall limit' incorporates:
       *  Constant: '<S17>/Constant1'
       */
      rtb_SineWave = -50.0 * rtb_sampletime_p;

      /* Switch: '<S26>/Switch' incorporates:
       *  RelationalOperator: '<S26>/UpperRelop'
       */
      if (rtb_UkYk1 < rtb_SineWave) {
        rtb_UkYk1 = rtb_SineWave;
      }

      rtb_SineWave = rtb_UkYk1;
    }

    /* Sum: '<S17>/Difference Inputs2' incorporates:
     *  UnitDelay: '<S17>/Delay Input2'
     */
    rtb_Yk_k = rtb_SineWave + Controller_DWork.s17_DelayInput2_DSTATE;

    /* Sum: '<S3>/Sum1' */
    rtb_Sum = rtb_Yk_k - Controller_B.s1_ReadCANMessage1_o2;

    /* UnitDelay: '<S15>/Unit Delay' */
    rtb_UnitDelay_b3 = Controller_DWork.s15_UnitDelay_DSTATE;

    /* Sum: '<S3>/Sum4' incorporates:
     *  Gain: '<S3>/Gain1'
     *  Product: '<S3>/Product2'
     *  S-Function (motohawk_sfun_calibration): '<S3>/motohawk_calibration'
     */
    rtb_SineWave = 0.1 * rtb_Sum * ConstantWork.mh_Current_Feedback_P_Gain +
      Controller_DWork.s15_UnitDelay_DSTATE;

    /* Sum: '<S3>/Sum2' incorporates:
     *  Product: '<S3>/Product1'
     *  Saturate: '<S3>/Saturation1'
     */
    rtb_Sum2 = Controller_B.s12_Current_Feedback_Enable * rt_SATURATE
      (rtb_SineWave, 0.0, 1.0) + Controller_B.s12_Throttle_Offset;

    /* Sum: '<S18>/Difference Inputs1' incorporates:
     *  UnitDelay: '<S18>/Delay Input2'
     */
    rtb_UkYk1 = rtb_Sum2 - Controller_DWork.s18_DelayInput2_DSTATE;

    /* Switch: '<S27>/Switch2' incorporates:
     *  RelationalOperator: '<S27>/LowerRelop1'
     */
    if (!(rtb_UkYk1 > rtb_Switch2)) {
      /* Product: '<S18>/delta fall limit' incorporates:
       *  Constant: '<S18>/Constant1'
       */
      rtb_SineWave = -rtb_sampletime_d;

      /* Switch: '<S27>/Switch' incorporates:
       *  RelationalOperator: '<S27>/UpperRelop'
       */
      if (rtb_UkYk1 < rtb_SineWave) {
        rtb_UkYk1 = rtb_SineWave;
      }

      rtb_Switch2 = rtb_UkYk1;
    }

    /* Sum: '<S18>/Difference Inputs2' incorporates:
     *  UnitDelay: '<S18>/Delay Input2'
     */
    Controller_B.s18_Yk = rtb_Switch2 + Controller_DWork.s18_DelayInput2_DSTATE;

    /* S-Function (sfix_tsampmath): '<S22>/sample time' */

    /* Sample Time Math Block: '<S22>/sample time'
     *
     * y = K         where     K = ( w * Ts )
     *
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * ElapsedTime Data Type:  Floating Point real_T
     */
    rtb_sampletime_h = (((Controller_DWork.root_Foreground_ELAPS_T * 1.0E-006))*
                        (1.0));

    /* Product: '<S22>/delta rise limit' incorporates:
     *  Constant: '<S22>/Constant'
     */
    rtb_SineWave = 10.0 * rtb_sampletime_h;

    /* Switch: '<S20>/Switch' incorporates:
     *  Constant: '<S20>/Constant'
     */
    if (Controller_B.s1_Sum1 >= 0.05) {
      rtb_Switch = 0.0;
    } else {
      rtb_Switch = Controller_B.s1_Sum;
    }

    /* Sum: '<S22>/Difference Inputs1' incorporates:
     *  UnitDelay: '<S22>/Delay Input2'
     */
    rtb_UkYk1 = rtb_Switch - Controller_DWork.s22_DelayInput2_DSTATE;

    /* Switch: '<S24>/Switch2' incorporates:
     *  RelationalOperator: '<S24>/LowerRelop1'
     */
    if (!(rtb_UkYk1 > rtb_SineWave)) {
      /* Product: '<S22>/delta fall limit' incorporates:
       *  Constant: '<S22>/Constant1'
       */
      rtb_SineWave = -10.0 * rtb_sampletime_h;

      /* Switch: '<S24>/Switch' incorporates:
       *  RelationalOperator: '<S24>/UpperRelop'
       */
      if (rtb_UkYk1 < rtb_SineWave) {
        rtb_UkYk1 = rtb_SineWave;
      }

      rtb_SineWave = rtb_UkYk1;
    }

    /* Sum: '<S22>/Difference Inputs2' incorporates:
     *  UnitDelay: '<S22>/Delay Input2'
     */
    rtb_Yk_e = rtb_SineWave + Controller_DWork.s22_DelayInput2_DSTATE;

    /* Abs: '<S11>/Abs' */
    rtb_Abs = fabs(Controller_B.s1_secondsperhour);

    /* Lookup Block: '<S11>/Disable Regen2'
     * About '<S11>/Disable Regen2 :'
     * Lookup Block: '<S11>/Disable Regen2'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_DisableRegen2), Controller_ConstP.pooled18,
                         rtb_Abs, Controller_ConstP.pooled17, 3U);

    /* Lookup Block: '<S11>/Disable Regen'
     * About '<S11>/Disable Regen :'
     * Lookup Block: '<S11>/Disable Regen'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_DisableRegen), Controller_ConstP.pooled20,
                         Controller_B.s1_ReadCANMessage_o1,
                         Controller_ConstP.pooled19, 3U);

    /* S-Function (sfix_tsampmath): '<S21>/sample time' */

    /* Sample Time Math Block: '<S21>/sample time'
     *
     * y = K         where     K = ( w * Ts )
     *
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * ElapsedTime Data Type:  Floating Point real_T
     */
    rtb_sampletime_n = (((Controller_DWork.root_Foreground_ELAPS_T * 1.0E-006))*
                        (1.0));

    /* Product: '<S21>/delta rise limit' incorporates:
     *  Constant: '<S21>/Constant'
     */
    rtb_SineWave = 10.0 * rtb_sampletime_n;

    /* Sum: '<S21>/Difference Inputs1' incorporates:
     *  UnitDelay: '<S21>/Delay Input2'
     */
    rtb_UkYk1 = Controller_B.s1_Sum1 - Controller_DWork.s21_DelayInput2_DSTATE;

    /* Switch: '<S23>/Switch2' incorporates:
     *  RelationalOperator: '<S23>/LowerRelop1'
     */
    if (!(rtb_UkYk1 > rtb_SineWave)) {
      /* Product: '<S21>/delta fall limit' incorporates:
       *  Constant: '<S21>/Constant1'
       */
      rtb_SineWave = -10.0 * rtb_sampletime_n;

      /* Switch: '<S23>/Switch' incorporates:
       *  RelationalOperator: '<S23>/UpperRelop'
       */
      if (rtb_UkYk1 < rtb_SineWave) {
        rtb_UkYk1 = rtb_SineWave;
      }

      rtb_SineWave = rtb_UkYk1;
    }

    /* Sum: '<S21>/Difference Inputs2' incorporates:
     *  UnitDelay: '<S21>/Delay Input2'
     */
    rtb_Yk_d = rtb_SineWave + Controller_DWork.s21_DelayInput2_DSTATE;

    /* Saturate: '<S20>/Saturation1' */
    rtb_Saturation1_i = rt_SATURATE(rtb_Yk_d, 0.0, 1.0);

    /* Lookup Block: '<S11>/Regen Braking'
     * About '<S11>/Regen Braking :'
     * Lookup Block: '<S11>/Regen Braking'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData is inlined and evenly spaced, so the algorithm only needs
     * the value of the first element, the last element, and the spacing.
     * For efficiency, XData is excluded from the generated code.
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUpEven_real_T_real_T( &(rtb_RegenBraking), Controller_ConstP.pooled22,
      rtb_Saturation1_i, 0.0, 2U, 0.5);

    /* Product: '<S11>/Product4' incorporates:
     *  Abs: '<S11>/Abs'
     *  Gain: '<S11>/Gain'
     *  Lookup: '<S11>/Disable Regen'
     *  Lookup: '<S11>/Disable Regen2'
     *  Lookup: '<S11>/Regen Braking'
     *  Product: '<S11>/Product'
     *  Product: '<S11>/Product2'
     *  Saturate: '<S20>/Saturation'
     *  Sum: '<S11>/Sum2'
     */
    Controller_B.s11_Product4 = (rtb_DisableRegen * rtb_RegenBraking *
      rtb_DisableRegen2 * -1.0 + rt_SATURATE(rtb_Yk_e, 0.0, 1.0)) *
      Controller_B.s19_Gear;

    /* Lookup Block: '<S11>/Foundation Braking'
     * About '<S11>/Foundation Braking :'
     * Lookup Block: '<S11>/Foundation Braking'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_FoundationBraking),
                         Controller_ConstP.FoundationBraking_YData,
                         rtb_Saturation1_i,
                         Controller_ConstP.FoundationBraking_XData, 2U);

    /* Lookup Block: '<S11>/Regen Braking1'
     * About '<S11>/Regen Braking1 :'
     * Lookup Block: '<S11>/Regen Braking1'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData is inlined and evenly spaced, so the algorithm only needs
     * the value of the first element, the last element, and the spacing.
     * For efficiency, XData is excluded from the generated code.
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUpEven_real_T_real_T( &(rtb_RegenBraking1), Controller_ConstP.pooled22,
      rtb_Saturation1_i, 0.0, 2U, 0.5);

    /* Lookup Block: '<S11>/Disable Regen1'
     * About '<S11>/Disable Regen1 :'
     * Lookup Block: '<S11>/Disable Regen1'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_DisableRegen1), Controller_ConstP.pooled20,
                         Controller_B.s1_ReadCANMessage_o1,
                         Controller_ConstP.pooled19, 3U);

    /* Abs: '<S11>/Abs1' */
    rtb_Abs1 = fabs(Controller_B.s1_secondsperhour);

    /* Lookup Block: '<S11>/Disable Regen3'
     * About '<S11>/Disable Regen3 :'
     * Lookup Block: '<S11>/Disable Regen3'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_DisableRegen3), Controller_ConstP.pooled18,
                         rtb_Abs1, Controller_ConstP.pooled17, 3U);

    /* Sum: '<S11>/Sum' incorporates:
     *  Abs: '<S11>/Abs1'
     *  Constant: '<S11>/Constant'
     *  Lookup: '<S11>/Disable Regen1'
     *  Lookup: '<S11>/Disable Regen3'
     *  Lookup: '<S11>/Foundation Braking'
     *  Lookup: '<S11>/Regen Braking1'
     *  Product: '<S11>/Product1'
     *  Product: '<S11>/Product3'
     *  Sum: '<S11>/Sum1'
     */
    Controller_B.s11_Foundation_Brake_Request = (1.0 - rtb_DisableRegen1 *
      rtb_DisableRegen3) * rtb_RegenBraking1 + rtb_FoundationBraking;

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x441 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          uint16_T tmp0;
          if (Controller_B.s18_Yk < 0.0000000000F) {
            tmp0 = (uint16_T)(0U);
          } else if (Controller_B.s18_Yk > 1.0000000000F) {
            tmp0 = (uint16_T)(65535U);
          } else {
            tmp0 = (uint16_T)(Controller_B.s18_Yk * (65535.0000000000F));
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[1])) ;
          msg_data[1] = ((((uint8_T *)(&tmp0))[0])) ;
          msg_data[2] = 0 ;
          msg_data[3] = 0 ;
          msg_data[4] = 0 ;
          msg_data[5] = 0 ;
          msg_data[6] = 0 ;
          msg_data[7] = 0 ;
          CAN_1_Transmit(0, 0x441UL, 8, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x451 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          int16_T tmp0;
          if (Controller_B.s3_Product < -1.0000610389F) {
            tmp0 = (int16_T)(-32768);
          } else if (Controller_B.s3_Product > 1.0000305194F) {
            tmp0 = (int16_T)(32767);
          } else {
            tmp0 = (int16_T)(Controller_B.s3_Product * (32766.0000000000F));
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[0])) ;
          msg_data[1] = ((((uint8_T *)(&tmp0))[1])) ;
          msg_data[2] = 0 ;
          msg_data[3] = 0 ;
          msg_data[4] = 0 ;
          msg_data[5] = 0 ;
          msg_data[6] = 0 ;
          msg_data[7] = 0 ;
          CAN_1_Transmit(0, 0x451UL, 8, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x461 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          int16_T tmp0;
          if (Controller_B.s11_Product4 < -1.0000610389F) {
            tmp0 = (int16_T)(-32768);
          } else if (Controller_B.s11_Product4 > 1.0000305194F) {
            tmp0 = (int16_T)(32767);
          } else {
            tmp0 = (int16_T)(Controller_B.s11_Product4 * (32766.0000000000F));
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[0])) ;
          msg_data[1] = ((((uint8_T *)(&tmp0))[1])) ;
          msg_data[2] = 0 ;
          msg_data[3] = 0 ;
          msg_data[4] = 0 ;
          msg_data[5] = 0 ;
          msg_data[6] = 0 ;
          msg_data[7] = 0 ;
          CAN_1_Transmit(0, 0x461UL, 8, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x462 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          uint8_T tmp0;
          if (Controller_B.s19_Motor_Enable < 0.0000000000F) {
            tmp0 = (uint8_T)(0U);
          } else if (Controller_B.s19_Motor_Enable > 255.0000000000F) {
            tmp0 = (uint8_T)(255U);
          } else {
            tmp0 = (uint8_T)(Controller_B.s19_Motor_Enable);
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[0])) ;
          CAN_1_Transmit(0, 0x462UL, 1, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x452 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          uint8_T tmp0;
          if (Controller_B.s19_Gen_Enable < 0.0000000000F) {
            tmp0 = (uint8_T)(0U);
          } else if (Controller_B.s19_Gen_Enable > 255.0000000000F) {
            tmp0 = (uint8_T)(255U);
          } else {
            tmp0 = (uint8_T)(Controller_B.s19_Gen_Enable);
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[0])) ;
          CAN_1_Transmit(0, 0x452UL, 1, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x431 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          uint8_T tmp0;
          if (Controller_B.s19_Battery_Connect_Command < 0.0000000000F) {
            tmp0 = (uint8_T)(0U);
          } else if (Controller_B.s19_Battery_Connect_Command > 255.0000000000F)
          {
            tmp0 = (uint8_T)(255U);
          } else {
            tmp0 = (uint8_T)(Controller_B.s19_Battery_Connect_Command);
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[0])) ;
          CAN_1_Transmit(0, 0x431UL, 1, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x470 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          uint8_T tmp0;
          if (Controller_B.s12_Engine_On < 0.0000000000F) {
            tmp0 = (uint8_T)(0U);
          } else if (Controller_B.s12_Engine_On > 255.0000000000F) {
            tmp0 = (uint8_T)(255U);
          } else {
            tmp0 = (uint8_T)(Controller_B.s12_Engine_On);
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[0])) ;
          CAN_1_Transmit(0, 0x470UL, 1, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* Send CAN Message(s) */
    {
      static uint32_T LastTxtime32 = 0;
      uint32_T time32;
      GetFreeRunningCounter32Bits(&time32);

      /* Transmit All Messages on Periodic Schedule (20.0 ms nominal) */
      /* Allow 0.5 ms "fuzz" to allow for different code execution paths on */
      /* subsequent block executions, e.g. long path followed by short path */
      if (((uint32_T)(time32 - LastTxtime32)) >= ((uint32_T)
           (19500U)
           )) {
        /* 0x480 */
        {
          extern boolean_T CAN_1_Transmit(boolean_T extended, uint32_T id,
            uint8_T length, const uint8_T data[]);
          uint8_T msg_data[8];
          uint16_T tmp0;
          if (Controller_B.s11_Foundation_Brake_Request < 0.0000000000F) {
            tmp0 = (uint16_T)(0U);
          } else if (Controller_B.s11_Foundation_Brake_Request > 1.0000000000F)
          {
            tmp0 = (uint16_T)(65535U);
          } else {
            tmp0 = (uint16_T)(Controller_B.s11_Foundation_Brake_Request *
                              (65535.0000000000F));
          }

          msg_data[0] = ((((uint8_T *)(&tmp0))[1])) ;
          msg_data[1] = ((((uint8_T *)(&tmp0))[0])) ;
          msg_data[2] = 0 ;
          msg_data[3] = 0 ;
          msg_data[4] = 0 ;
          msg_data[5] = 0 ;
          msg_data[6] = 0 ;
          msg_data[7] = 0 ;
          CAN_1_Transmit(0, 0x480UL, 8, msg_data);
        }

        LastTxtime32 = time32;
      }
    }

    /* S-Function Block: FUELP */
    {
    }

    /* S-Function Block: TACH */
    {
    }

    /* S-Function Block: INJ1D */
    {
    }

    /* S-Function Block: INJ2D */
    {
    }

    /* S-Function Block: INJ3D */
    {
    }

    /* Product: '<S3>/Product4' incorporates:
     *  S-Function (motohawk_sfun_calibration): '<S3>/motohawk_calibration2'
     */
    rtb_SineWave = rtb_Sum_c * ConstantWork.mh_Speed_Feedback_I_Gain;

    /* Product: '<S3>/Product5' incorporates:
     *  S-Function (motohawk_sfun_calibration): '<S3>/motohawk_calibration3'
     */
    rtb_UkYk1 = rtb_Sum * ConstantWork.mh_Current_Feedback_I_Gain;

    /* S-Function Block: <S14>/motohawk_delta_time */
    {
      uint32_T delta;
      uint32_T now;
      GetFreeRunningCounter32Bits(&now);
      delta = now - Controller_DWork.s14_motohawk_delta_time_DWORK1;
      Controller_DWork.s14_motohawk_delta_time_DWORK1 = now;
      rtb_motohawk_delta_time = ((real_T) delta) * 0.000001;
    }

    /* Sum: '<S14>/Sum' incorporates:
     *  Product: '<S14>/Product'
     *  S-Function (motohawk_sfun_delta_time): '<S14>/motohawk_delta_time'
     */
    rtb_Sum = rtb_SineWave * rtb_motohawk_delta_time + rtb_UnitDelay_l;

    /* Saturate: '<S14>/Saturation' */
    rtb_Switch2 = rt_SATURATE(rtb_Sum, -1.0, 1.0);

    /* S-Function Block: <S15>/motohawk_delta_time */
    {
      uint32_T delta;
      uint32_T now;
      GetFreeRunningCounter32Bits(&now);
      delta = now - Controller_DWork.s15_motohawk_delta_time_DWORK1;
      Controller_DWork.s15_motohawk_delta_time_DWORK1 = now;
      rtb_motohawk_delta_time_k = ((real_T) delta) * 0.000001;
    }

    /* Sum: '<S15>/Sum' incorporates:
     *  Product: '<S15>/Product'
     *  S-Function (motohawk_sfun_delta_time): '<S15>/motohawk_delta_time'
     */
    rtb_Sum = rtb_UkYk1 * rtb_motohawk_delta_time_k + rtb_UnitDelay_b3;

    /* If: '<S6>/If' incorporates:
     *  ActionPort: '<S28>/Action Port'
     *  ActionPort: '<S29>/Action Port'
     *  S-Function (motohawk_sfun_calibration): '<S6>/override_enable'
     *  SubSystem: '<S6>/NewValue'
     *  SubSystem: '<S6>/OldValue'
     */
    if (VolatileWork.mh_Park_LED_ovr) {
      /* Inport: '<S28>/In1' incorporates:
       *  S-Function (motohawk_sfun_calibration): '<S6>/new_value'
       */
      rtb_SineWave = VolatileWork.mh_Park_LED_new;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs/NewValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(1);
      }
    } else {
      /* Inport: '<S29>/In1' */
      rtb_SineWave = Controller_B.s19_Park_LED;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs/OldValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(2);
      }
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion3' */
    rtb_DataTypeConversion3 = (rtb_SineWave != 0.0);

    /* If: '<S7>/If' incorporates:
     *  ActionPort: '<S30>/Action Port'
     *  ActionPort: '<S31>/Action Port'
     *  S-Function (motohawk_sfun_calibration): '<S7>/override_enable'
     *  SubSystem: '<S7>/NewValue'
     *  SubSystem: '<S7>/OldValue'
     */
    if (VolatileWork.mh_Forward_LED_ovr) {
      /* Inport: '<S30>/In1' incorporates:
       *  S-Function (motohawk_sfun_calibration): '<S7>/new_value'
       */
      rtb_SineWave = VolatileWork.mh_Forward_LED_new;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs1/NewValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(3);
      }
    } else {
      /* Inport: '<S31>/In1' */
      rtb_SineWave = Controller_B.s19_Forward_LED;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs1/OldValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(4);
      }
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion4' */
    rtb_DataTypeConversion4 = (rtb_SineWave != 0.0);

    /* If: '<S8>/If' incorporates:
     *  ActionPort: '<S32>/Action Port'
     *  ActionPort: '<S33>/Action Port'
     *  S-Function (motohawk_sfun_calibration): '<S8>/override_enable'
     *  SubSystem: '<S8>/NewValue'
     *  SubSystem: '<S8>/OldValue'
     */
    if (VolatileWork.mh_Reverse_LED_ovr) {
      /* Inport: '<S32>/In1' incorporates:
       *  S-Function (motohawk_sfun_calibration): '<S8>/new_value'
       */
      rtb_SineWave = VolatileWork.mh_Reverse_LED_new;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs2/NewValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(5);
      }
    } else {
      /* Inport: '<S33>/In1' */
      rtb_SineWave = Controller_B.s19_Reverse_LED;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs2/OldValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(6);
      }
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion5' */
    rtb_DataTypeConversion5 = (rtb_SineWave != 0.0);

    /* If: '<S9>/If' incorporates:
     *  ActionPort: '<S34>/Action Port'
     *  ActionPort: '<S35>/Action Port'
     *  S-Function (motohawk_sfun_calibration): '<S9>/override_enable'
     *  SubSystem: '<S9>/NewValue'
     *  SubSystem: '<S9>/OldValue'
     */
    if (VolatileWork.mh_Error_LED_ovr) {
      /* Inport: '<S34>/In1' incorporates:
       *  S-Function (motohawk_sfun_calibration): '<S9>/new_value'
       */
      rtb_SineWave = VolatileWork.mh_Error_LED_new;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs3/NewValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(7);
      }
    } else {
      /* Inport: '<S35>/In1' */
      rtb_SineWave = Controller_B.s19_Error;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs3/OldValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(8);
      }
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion6' */
    rtb_DataTypeConversion6 = (rtb_SineWave != 0.0);

    /* If: '<S10>/If' incorporates:
     *  ActionPort: '<S36>/Action Port'
     *  ActionPort: '<S37>/Action Port'
     *  S-Function (motohawk_sfun_calibration): '<S10>/override_enable'
     *  SubSystem: '<S10>/NewValue'
     *  SubSystem: '<S10>/OldValue'
     */
    if (VolatileWork.mh_Vehicle_Ready_LED_ovr) {
      /* Inport: '<S36>/In1' incorporates:
       *  S-Function (motohawk_sfun_calibration): '<S10>/new_value'
       */
      rtb_SineWave = VolatileWork.mh_Vehicle_Ready_LED_new;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs4/NewValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(9);
      }
    } else {
      /* Inport: '<S37>/In1' */
      rtb_SineWave = Controller_B.s19_Vehicle_Ready;

      /* Code Coverage Test: Controller/Foreground/motohawk_override_abs4/OldValue */
      {
        extern void MH_CodeCovered(uint32_T idx);
        MH_CodeCovered(10);
      }
    }

    /* DataTypeConversion: '<S1>/Data Type Conversion7' */
    rtb_DataTypeConversion7 = (rtb_SineWave != 0.0);

    /* Code Coverage Test: Controller/Foreground */
    {
      extern void MH_CodeCovered(uint32_T idx);
      MH_CodeCovered(0);
    }

    /* Update for UnitDelay: '<S16>/Delay Input2' */
    Controller_DWork.s16_DelayInput2_DSTATE = rtb_Yk;

    /* Update for UnitDelay: '<S14>/Unit Delay' */
    Controller_DWork.s14_UnitDelay_DSTATE = rtb_Switch2;

    /* DiscreteTransferFcn Block: '<S13>/Discrete Transfer Fcn' */
    {
      Controller_DWork.s13_DiscreteTransferFcn_DSTATE = rtb_Gain_a +
        9.9686333183343789E-001*Controller_DWork.s13_DiscreteTransferFcn_DSTATE;
    }

    /* Update for UnitDelay: '<S17>/Delay Input2' */
    Controller_DWork.s17_DelayInput2_DSTATE = rtb_Yk_k;

    /* Update for UnitDelay: '<S15>/Unit Delay' incorporates:
     *  Saturate: '<S15>/Saturation'
     */
    Controller_DWork.s15_UnitDelay_DSTATE = rt_SATURATE(rtb_Sum, -1.0, 1.0);

    /* Update for UnitDelay: '<S18>/Delay Input2' */
    Controller_DWork.s18_DelayInput2_DSTATE = Controller_B.s18_Yk;

    /* Update for UnitDelay: '<S22>/Delay Input2' */
    Controller_DWork.s22_DelayInput2_DSTATE = rtb_Yk_e;

    /* Update for UnitDelay: '<S21>/Delay Input2' */
    Controller_DWork.s21_DelayInput2_DSTATE = rtb_Yk_d;

    /* S-Function Block: FUELP */
    {
      if ((VolatileWork.mh_init_resource_FUELP < 0) && (((int32_T) RES_FUELP) >=
           0)) {
        S_DiscreteOutCreateAttributes CreateInfo;
        NativeError_S sErrorResult;
        CreateInfo.DynamicObj.eState = (rtb_DataTypeConversion3) ? RES_ON :
          RES_OFF;
        CreateInfo.DynamicObj.eResourceCondition = RES_ENABLED;
        CreateInfo.DynamicObj.uValidAttributesMask = USE_DISCRETE_CONDITION |
          USE_DISCRETE_STATE;
        CreateInfo.uValidAttributesMask = USE_DISCRETE_DYNAMIC_ON_CREATE;
        sErrorResult = CreateResource((E_ModuleResource) (((int32_T) RES_FUELP)),
          &CreateInfo, BEHAVIOUR_DISCRETE_OUT);
        if (SUCCESS(sErrorResult)) {
          VolatileWork.mh_init_resource_FUELP = ((int32_T) RES_FUELP);
        } else {
          VolatileWork.mh_init_resource_FUELP = -1;
          LogNativeError(sErrorResult);
        }

        {
          extern uint8_T dout_create_FUELP;
          if (SUCCESS(sErrorResult))
            dout_create_FUELP = 0;
          else
            dout_create_FUELP = (uint8_T) GetErrorCode(sErrorResult);
        }
      } else if (VolatileWork.mh_init_resource_FUELP >= 0) {
        SetDiscreteOutState((E_ModuleResource)
                            (VolatileWork.mh_init_resource_FUELP),
                            (rtb_DataTypeConversion3) ? RES_ON : RES_OFF);
      }
    }

    /* S-Function Block: TACH */
    {
      if ((VolatileWork.mh_init_resource_TACH < 0) && (((int32_T) RES_TACH) >= 0))
      {
        S_DiscreteOutCreateAttributes CreateInfo;
        NativeError_S sErrorResult;
        CreateInfo.DynamicObj.eState = (rtb_DataTypeConversion4) ? RES_ON :
          RES_OFF;
        CreateInfo.DynamicObj.eResourceCondition = RES_ENABLED;
        CreateInfo.DynamicObj.uValidAttributesMask = USE_DISCRETE_CONDITION |
          USE_DISCRETE_STATE;
        CreateInfo.uValidAttributesMask = USE_DISCRETE_DYNAMIC_ON_CREATE;
        sErrorResult = CreateResource((E_ModuleResource) (((int32_T) RES_TACH)),
          &CreateInfo, BEHAVIOUR_DISCRETE_OUT);
        if (SUCCESS(sErrorResult)) {
          VolatileWork.mh_init_resource_TACH = ((int32_T) RES_TACH);
        } else {
          VolatileWork.mh_init_resource_TACH = -1;
          LogNativeError(sErrorResult);
        }

        {
          extern uint8_T dout_create_TACH;
          if (SUCCESS(sErrorResult))
            dout_create_TACH = 0;
          else
            dout_create_TACH = (uint8_T) GetErrorCode(sErrorResult);
        }
      } else if (VolatileWork.mh_init_resource_TACH >= 0) {
        SetDiscreteOutState((E_ModuleResource)
                            (VolatileWork.mh_init_resource_TACH),
                            (rtb_DataTypeConversion4) ? RES_ON : RES_OFF);
      }
    }

    /* S-Function Block: INJ1D */
    {
      if ((VolatileWork.mh_init_resource_INJ1D < 0) && (((int32_T) RES_INJ1D) >=
           0)) {
        S_DiscreteOutCreateAttributes CreateInfo;
        NativeError_S sErrorResult;
        CreateInfo.DynamicObj.eState = (rtb_DataTypeConversion5) ? RES_ON :
          RES_OFF;
        CreateInfo.DynamicObj.eResourceCondition = RES_ENABLED;
        CreateInfo.DynamicObj.uValidAttributesMask = USE_DISCRETE_CONDITION |
          USE_DISCRETE_STATE;
        CreateInfo.uValidAttributesMask = USE_DISCRETE_DYNAMIC_ON_CREATE;
        sErrorResult = CreateResource((E_ModuleResource) (((int32_T) RES_INJ1D)),
          &CreateInfo, BEHAVIOUR_DISCRETE_OUT);
        if (SUCCESS(sErrorResult)) {
          VolatileWork.mh_init_resource_INJ1D = ((int32_T) RES_INJ1D);
        } else {
          VolatileWork.mh_init_resource_INJ1D = -1;
          LogNativeError(sErrorResult);
        }

        {
          extern uint8_T dout_create_INJ1D;
          if (SUCCESS(sErrorResult))
            dout_create_INJ1D = 0;
          else
            dout_create_INJ1D = (uint8_T) GetErrorCode(sErrorResult);
        }
      } else if (VolatileWork.mh_init_resource_INJ1D >= 0) {
        SetDiscreteOutState((E_ModuleResource)
                            (VolatileWork.mh_init_resource_INJ1D),
                            (rtb_DataTypeConversion5) ? RES_ON : RES_OFF);
      }
    }

    /* S-Function Block: INJ2D */
    {
      if ((VolatileWork.mh_init_resource_INJ2D < 0) && (((int32_T) RES_INJ2D) >=
           0)) {
        S_DiscreteOutCreateAttributes CreateInfo;
        NativeError_S sErrorResult;
        CreateInfo.DynamicObj.eState = (rtb_DataTypeConversion6) ? RES_ON :
          RES_OFF;
        CreateInfo.DynamicObj.eResourceCondition = RES_ENABLED;
        CreateInfo.DynamicObj.uValidAttributesMask = USE_DISCRETE_CONDITION |
          USE_DISCRETE_STATE;
        CreateInfo.uValidAttributesMask = USE_DISCRETE_DYNAMIC_ON_CREATE;
        sErrorResult = CreateResource((E_ModuleResource) (((int32_T) RES_INJ2D)),
          &CreateInfo, BEHAVIOUR_DISCRETE_OUT);
        if (SUCCESS(sErrorResult)) {
          VolatileWork.mh_init_resource_INJ2D = ((int32_T) RES_INJ2D);
        } else {
          VolatileWork.mh_init_resource_INJ2D = -1;
          LogNativeError(sErrorResult);
        }

        {
          extern uint8_T dout_create_INJ2D;
          if (SUCCESS(sErrorResult))
            dout_create_INJ2D = 0;
          else
            dout_create_INJ2D = (uint8_T) GetErrorCode(sErrorResult);
        }
      } else if (VolatileWork.mh_init_resource_INJ2D >= 0) {
        SetDiscreteOutState((E_ModuleResource)
                            (VolatileWork.mh_init_resource_INJ2D),
                            (rtb_DataTypeConversion6) ? RES_ON : RES_OFF);
      }
    }

    /* S-Function Block: INJ3D */
    {
      if ((VolatileWork.mh_init_resource_INJ3D < 0) && (((int32_T) RES_INJ3D) >=
           0)) {
        S_DiscreteOutCreateAttributes CreateInfo;
        NativeError_S sErrorResult;
        CreateInfo.DynamicObj.eState = (rtb_DataTypeConversion7) ? RES_ON :
          RES_OFF;
        CreateInfo.DynamicObj.eResourceCondition = RES_ENABLED;
        CreateInfo.DynamicObj.uValidAttributesMask = USE_DISCRETE_CONDITION |
          USE_DISCRETE_STATE;
        CreateInfo.uValidAttributesMask = USE_DISCRETE_DYNAMIC_ON_CREATE;
        sErrorResult = CreateResource((E_ModuleResource) (((int32_T) RES_INJ3D)),
          &CreateInfo, BEHAVIOUR_DISCRETE_OUT);
        if (SUCCESS(sErrorResult)) {
          VolatileWork.mh_init_resource_INJ3D = ((int32_T) RES_INJ3D);
        } else {
          VolatileWork.mh_init_resource_INJ3D = -1;
          LogNativeError(sErrorResult);
        }

        {
          extern uint8_T dout_create_INJ3D;
          if (SUCCESS(sErrorResult))
            dout_create_INJ3D = 0;
          else
            dout_create_INJ3D = (uint8_T) GetErrorCode(sErrorResult);
        }
      } else if (VolatileWork.mh_init_resource_INJ3D >= 0) {
        SetDiscreteOutState((E_ModuleResource)
                            (VolatileWork.mh_init_resource_INJ3D),
                            (rtb_DataTypeConversion7) ? RES_ON : RES_OFF);
      }
    }
  }
}

/* File trailer for Real-Time Workshop generated code.
 *
 * [EOF]
 */
